# code-input

![Click to Switch](https://img.shields.io/static/v1?label=&message=Click%20to%20Switch:%20&color=grey&style=for-the-badge)[![Website and Demos](https://img.shields.io/static/v1?label=&message=Website&color=444400&style=for-the-badge)](https://code-input-js.org)[![GitHub](https://img.shields.io/static/v1?label=&message=GitHub&color=black&style=for-the-badge&logo=github)](https://github.com/WebCoder49/code-input)[![Codeberg](https://img.shields.io/static/v1?label=&message=Codeberg&color=navy&style=for-the-badge&logo=codeberg)](https://codeberg.org/code-input-js/code-input-js)[![Yarn](https://img.shields.io/static/v1?label=&message=Yarn&color=purple&style=for-the-badge&logo=yarn)](https://yarnpkg.com/package?name=@webcoder49/code-input)[![NPM](https://img.shields.io/static/v1?label=&message=NPM&color=red&style=for-the-badge&logo=npm)](https://www.npmjs.com/package/@webcoder49/code-input)

[![View License](https://img.shields.io/github/license/webcoder49/code-input?color=darkgreen&style=for-the-badge)](LICENSE) [![View Releases](https://img.shields.io/github/v/release/webcoder49/code-input?style=for-the-badge)](https://github.com/WebCoder49/code-input/releases) 
> **An editable &lt;textarea&gt; that supports *any* syntax highlighting algorithm, for code or something else. Also, added plugins.**
> 
> Aiming to be more flexible, lightweight, modular, progressively enhanced and standards-based than the alternatives, we support HTML forms, the `<textarea>` JavaScript interface, more languages and more use cases.

---

Demos and usage instructions are available at <https://code-input-js.org> and [the `docs` directory](docs/), to let you get started quickly!

---

A lightweight setup like the animation below is still the default for `code-input.js`, but a wide range of plugins are available to modularly and progressively enhance the experience - see [the website](https://code-input-js.org) for interactive demos!

![Using code-input with many different themes](https://user-images.githubusercontent.com/69071853/133924472-05edde5c-23e7-4350-a41b-5a74d2dc1a9a.gif)
*This demonstration uses themes from [Prism.js](https://prismjs.com/) and [highlight.js](https://highlightjs.org/), two syntax-highlighting programs which work well with and have compatibility built-in with code-input.*

## Contributing
If you have any features you would like to add to `code-input` as plugins or core functionality, or have found any bugs, please [open an issue](https://github.com/WebCoder49/code-input/issues) or [fork and submit a pull request](https://github.com/WebCoder49/code-input/fork)! All contributions to this open-source project will be greatly appreciated. You can see [more info in our `CONTRIBUTING.md` file](CONTRIBUTING.md).

**If you find a sensitive security vulnerability in the code-input.js library, please email the maintainer Oliver Geer at [security@webcoder49.dev](mailto:security@webcoder49.dev), optionally using [this encryption key](https://ogeer.org#pgp). GitHub security advisories (different to the more general "issues") are also accepted.**


|[![Contributors](https://contrib.rocks/image?repo=WebCoder49%2Fcode-input)](https://github.com/WebCoder49/code-input/graphs/contributors)|
|---|
|...have contributed pull requests so far.|
|(source: [contrib.rocks](https://contrib.rocks))|
